/*
Commentaires en gris
Yvon Quémener
Jean-Francois Garneau
*/

#include <LiquidCrystal.h>   // on appele la librairie nécessaire à l'affichage ACL
LiquidCrystal lcd(8, 9, 4, 5, 6, 7);  // on définie les broches utilisées par l'écran ACL qui s'enfiche sur le arduino

 // déclaration des variables et des constantes  
    const int sortie = 3;   // Broche Positif de la DEL
    const int gnd = 2;   // Broche de Gnd de la DEL
    int sig_btn;   // signal capté sur la broche A0 (boutons)
    int reg_temp;  // température désirée (réglage avec les boutons)  
    int offset; // calibration de la sonde

    
    // gestion de la sonde et de la moyenne
    int sig_temp = 0;     // variable qui contient le signal A1
    int tab_c [ 10 ] ;    // Variable qui contient les 10 dernières écriture provenant de la sonde (array)
    int cellule = 0 ;     // cellule 0 à 9 qui détermine la position d'écriture dans le tableau
    float moyenne = 0 ;     // Moyenne des 10 lectures du tableau
      

void setup()   // le "setup" est exécuté une seule fois au début du programme
    {
    reg_temp = 43; // temperature réglée par defaut
    offset = 500; //offset par défaut (selon la fiche technique du TMP36)  
      
    pinMode(sortie, OUTPUT);      // broche de raccordement du positif de la DEL
    pinMode(gnd, OUTPUT);      // broche de raccordement du négatif de la DEL
    lcd.begin(16, 2);   // définition du type d'affichage utilisé : 16 caractères, 2 lignes.
    Serial.begin(9600);   // initialisation du port série à 9600 bauds
    lcd.print("YAOURTIERE");   // message
    delay( 3000 );   // délai de 3 secondes pour identifier le projet au départ
    lcd.clear();   // effacement de l'affichage ACL et positionnement du curseur en haut à gauche
    lcd.print("REGLAGE TEMP."); // message
    lcd.setCursor(0, 1);  // le chiffre 1 représente la ligne 1 (deuxième ligne de l'affichage) 
    lcd.print("HAUT - BAS");   // message 
    delay( 3000 );   // délai de 3 secondes 
    lcd.clear();   // effacement de l'affichage ACL et positionnement du curseur en haut à gauche
    lcd.print("CALIB. SONDE"); // message
    lcd.setCursor(0, 1);  // le chiffre 1 représente la ligne 1 (deuxième ligne de l'affichage) 
    lcd.print("GAUCHE - DROIT");   // message 
    delay( 3000 );   // délai de 3 secondes 


}

void loop()   // la "loop" s'exécute continuellement
  {
   // Mesure de la sonde et écriture dans une cellule du tableau "tab_c"
      sig_temp = analogRead(A1) ;     
      tab_c[cellule] =((sig_temp*5000.0/1023)-offset)/10; // conversion signal en degrés C
      Serial.println ( sig_temp );  // affichage de A1 sur le moniteur série pour déboguage
   
   // calcul de la moyenne des 10 cellules du tableau "tab_c"
      int somme = 0 ;
      for (int i = 0 ; i < 10 ; i++)
      {
      somme += tab_c[i] ;
      }
      moyenne = somme / 10.0 ; 
       
   // changement de cellule dans le tableau en vue de la prochaine écriture
      cellule = cellule + 1;
      if ( cellule >= 10 )       
      {
      cellule = 0 ;
      }
  
   // Contrôle de la sortie LOW ou HIGH 
      if ((moyenne+1) < reg_temp) // +1 : hystérésis pour éviter la commutation trop rapide
      {
      digitalWrite(sortie, LOW);
      }   
     
      if ((moyenne-1) > reg_temp) // -1 : hystérésis pour éviter la commutation trop rapide
      {
      digitalWrite(sortie, HIGH);
      }
    
   
   // réglage de la température désirée
      sig_btn = analogRead(A0) ;   
      if (( sig_btn >= 100 ) && ( sig_btn <= 200 ))
      {
      reg_temp = reg_temp + 1;
      }   
    
      if (( sig_btn >= 300 ) && ( sig_btn <= 400 ))
      {
      reg_temp = reg_temp - 1;
      }    
 
   // réglage de la calibration de la sonde
      sig_btn = analogRead(A0) ;   
      if (( sig_btn >= 0 ) && ( sig_btn <= 100 ))
      {
      offset = offset - 2;
      }   
    
      if (( sig_btn >= 450 ) && ( sig_btn <= 550 ))
      {
      offset = offset + 2;
      }  
      
  // affichage du message sur l'écran  
     lcd.clear();   // effacement de l'affichage acl et positionnement du curseur en haut à gauche
     lcd.print("REGLAGE= ");   // affichage sur l'écran ACL du mot "TEMPÉRATURE"
     lcd.print( reg_temp, 1 );    // Affichage de la température. Le chiffre 1 représente le nombre de chiffres après la virgule.   
     lcd.print(" C");    // affichage sur l'écran ACL du la lettre C
     lcd.setCursor(0, 1);  // le chiffre 1 représente la ligne 1 (deuxième ligne de l'affichage) 
     lcd.print("MESURE= ");   // affichage sur l'écran ACL du message "A1 ="     
     lcd.print( moyenne , 1);    //  affichage du signal. DEC après la virgule pour définir le format décimal en base 10    
     lcd.print(" C");    // affichage sur l'écran ACL du la lettre C
     delay( 500 );   // délai de 1 secondes qui permet de stabiliser l'écran ACL         
     
  }


